<?php
require_once '../config.php';
require_once '../db_connection.php';

session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);
$user_id = $_SESSION['user_id'];

// Current user check
$user = $db->select('users', 'password', ['id' => $user_id])[0];

if (!password_verify($data['current_password'], $user['password'])) {
    echo json_encode(['success' => false, 'message' => 'Current password is incorrect']);
    exit();
}

// Update password
$hashed = password_hash($data['new_password'], PASSWORD_DEFAULT);
$db->update('users', ['password' => $hashed], ['id' => $user_id]);

echo json_encode(['success' => true, 'message' => 'Password updated']);
?>