<?php
// index.php
require_once 'config.php';
require_once 'db_connection.php';

// যদি ইউজার লগিন করা থাকে
if (isset($_SESSION['user_id'])) {
    header('Location: user.php');
    exit();
}

// যদি অ্যাডমিন লগিন করা থাকে
if (isset($_SESSION['admin_id'])) {
    header('Location: admin.php');
    exit();
}

$error = '';
$success = '';

// লগিন প্রসেস
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['login'])) {
    $phone = $db->sanitize($_POST['phone']);
    $password = $_POST['password'];
    
    // ভ্যালিডেশন
    if (empty($phone) || empty($password)) {
        $error = 'ফোন নাম্বার এবং পাসওয়ার্ড দিন';
    } else {
        // ব্রুট ফোর্স চেক
        $ip = $_SERVER['REMOTE_ADDR'];
        $hour_ago = date('Y-m-d H:i:s', strtotime('-1 hour'));
        $attempts = $db->select('login_attempts', 'COUNT(*) as count', [
            'ip_address' => $ip,
            'attempt_time >=' => $hour_ago,
            'success' => 0
        ]);
        
        if ($attempts[0]['count'] >= MAX_LOGIN_ATTEMPTS) {
            $error = 'বহুবার চেষ্টা করেছেন। ১ ঘণ্টা পর আবার চেষ্টা করুন।';
        } else {
            // ইউজার খুঁজুন
            $user = $db->select('users', '*', ['phone' => $phone]);
            
            if ($user && password_verify($password, $user[0]['password'])) {
                // লগিন সফল
                $_SESSION['user_id'] = $user[0]['id'];
                $_SESSION['user_uid'] = $user[0]['uid'];
                $_SESSION['user_name'] = $user[0]['name'];
                $_SESSION['user_phone'] = $user[0]['phone'];
                $_SESSION['user_ui_id'] = $user[0]['ui_id'];
                
                // লগ আপডেট
                $db->update('users', [
                    'last_login' => date('Y-m-d H:i:s')
                ], ['id' => $user[0]['id']]);
                
                // লগিন অ্যাটেম্পট রেকর্ড
                $db->insert('login_attempts', [
                    'ip_address' => $ip,
                    'phone' => $phone,
                    'attempt_time' => date('Y-m-d H:i:s'),
                    'success' => 1,
                    'user_agent' => $_SERVER['HTTP_USER_AGENT']
                ]);
                
                header('Location: user.php');
                exit();
            } else {
                $error = 'ফোন নাম্বার বা পাসওয়ার্ড ভুল';
                // ফেইলড অ্যাটেম্পট রেকর্ড
                $db->insert('login_attempts', [
                    'ip_address' => $ip,
                    'phone' => $phone,
                    'attempt_time' => date('Y-m-d H:i:s'),
                    'success' => 0,
                    'user_agent' => $_SERVER['HTTP_USER_AGENT']
                ]);
            }
        }
    }
}

// রেজিস্ট্রেশন প্রসেস
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['register'])) {
    $name = $db->sanitize($_POST['name']);
    $phone = $db->sanitize($_POST['phone']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    $referral_code = $db->sanitize($_POST['referral_code'] ?? '');
    
    // ভ্যালিডেশন
    if (empty($name) || empty($phone) || empty($password)) {
        $error = 'সব তথ্য পূরণ করুন';
    } elseif ($password !== $confirm_password) {
        $error = 'পাসওয়ার্ড মেলেনি';
    } elseif (strlen($password) < 6) {
        $error = 'পাসওয়ার্ড কমপক্ষে ৬ অক্ষরের হতে হবে';
    } elseif (!preg_match('/^01[3-9]\d{8}$/', $phone)) {
        $error = 'সঠিক ফোন নাম্বার দিন';
    } else {
        // ফোন নম্বর চেক
        $existing = $db->select('users', 'id', ['phone' => $phone]);
        if ($existing) {
            $error = 'এই ফোন নম্বর ইতিমধ্যে রেজিস্টার্ড';
        } else {
            // রেফারেল কোড চেক
            $referrer_id = null;
            if (!empty($referral_code)) {
                $referrer = $db->select('users', 'id, ui_id', ['ui_id' => $referral_code]);
                if ($referrer) {
                    $referrer_id = $referrer[0]['id'];
                } else {
                    $error = 'ভুল রেফারেল কোড';
                }
            }
            
            if (!$error) {
                // ইউনিক ID তৈরি
                $uid = uniqid('user_');
                $ui_id = rand(100000, 999999);
                
                // ইউজার তৈরি
                $user_data = [
                    'uid' => $uid,
                    'ui_id' => $ui_id,
                    'name' => $name,
                    'phone' => $phone,
                    'password' => password_hash($password, PASSWORD_DEFAULT),
                    'deposit_balance' => WELCOME_BONUS,
                    'used_referral_code' => $referral_code,
                    'created_at' => date('Y-m-d H:i:s')
                ];
                
                $result = $db->insert('users', $user_data);
                
                if (isset($result['error'])) {
                    $error = 'রেজিস্ট্রেশন ব্যর্থ হয়েছে: ' . $result['error'];
                } else {
                    // রেফারেল বোনাস
                    if ($referrer_id) {
                        $db->query("UPDATE users SET total_referrals = total_referrals + 1 WHERE id = ?", [$referrer_id]);
                        $db->query("UPDATE users SET total_bonus = total_bonus + ? WHERE id = ?", [REFERRAL_BONUS, $referrer_id]);
                    }
                    
                    $success = 'রেজিস্ট্রেশন সফল! আপনার UI ID: ' . $ui_id;
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?> - লগিন</title>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@400;700&family=Roboto+Mono:wght@700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="styles.css">
    <style>
        /* SPLASH SCREEN STYLES */
        #splash-screen {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: #000000;
            z-index: 99999;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            transition: opacity 0.5s ease-out, visibility 0.5s;
        }
        #splash-screen.hidden {
            opacity: 0;
            visibility: hidden;
            pointer-events: none;
        }
        .splash-loader {
            width: 50px;
            height: 50px;
            border: 5px solid rgba(0, 255, 200, 0.2);
            border-top: 5px solid #00ffc8;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            position: absolute;
            top: 10%;
            z-index: 2;
        }
        .splash-image-container {
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0;
        }
        .splash-image-container img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            animation: zoomIn 3s ease-out;
        }
        @keyframes zoomIn {
            0% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        @keyframes spin {
            100% { transform: rotate(360deg); }
        }
        
        /* AUTH STYLES */
        .auth-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 20px;
            background: linear-gradient(-45deg, #0e0e0e, #1a1a1a, #2c2c2e, #001f3f);
            background-size: 400% 400%;
            animation: auth-bg-animation 15s ease infinite;
        }
        @keyframes auth-bg-animation {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        .auth-card {
            background: rgba(31, 31, 31, 0.85);
            backdrop-filter: blur(10px);
            border-radius: 14px;
            padding: 30px;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 8px 32px 0 rgba(0, 255, 200, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.18);
        }
        .auth-logo {
            text-align: center;
            margin-bottom: 25px;
        }
        .auth-logo h1 {
            font-size: 2.2em;
            color: #00ffc8;
            margin-bottom: 5px;
            text-shadow: 0 0 10px #00ffc8;
        }
        .auth-logo p {
            color: #a9a9b3;
            font-size: 0.9em;
        }
        .auth-tabs {
            display: flex;
            margin-bottom: 25px;
            background-color: #2c2c2e;
            border-radius: 8px;
            overflow: hidden;
            padding: 4px;
        }
        .auth-tab {
            flex: 1;
            background: transparent;
            border: none;
            color: #a9a9b3;
            padding: 12px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s;
            border-radius: 6px;
            font-size: 0.95em;
        }
        .auth-tab.active {
            background-color: #00ffc8;
            color: #0e0e0e;
        }
        .auth-form {
            display: flex;
            flex-direction: column;
            gap: 18px;
        }
        .form-group {
            display: flex;
            flex-direction: column;
            gap: 8px;
        }
        .form-group label {
            font-weight: 600;
            color: #a9a9b3;
            font-size: 0.9em;
        }
        .form-group input {
            padding: 14px 15px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            background-color: #2c2c2e;
            color: #ffffff;
            font-size: 1em;
            transition: border-color 0.3s, box-shadow 0.3s;
        }
        .form-group input:focus {
            outline: none;
            border-color: #00ffc8;
            box-shadow: 0 0 8px rgba(0, 255, 200, 0.3);
        }
        .submit-btn {
            background: linear-gradient(135deg, #00ffc8, #00aaff);
            color: #0e0e0e;
            border: none;
            padding: 15px;
            border-radius: 8px;
            font-size: 1.1em;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
            margin-top: 10px;
        }
        .submit-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 15px rgba(0, 255, 200, 0.3);
        }
        .alert {
            padding: 12px 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 0.9em;
            text-align: center;
        }
        .alert-error {
            background-color: rgba(244, 67, 54, 0.2);
            color: #ff6b6b;
            border: 1px solid #ff6b6b;
        }
        .alert-success {
            background-color: rgba(76, 175, 80, 0.2);
            color: #81C784;
            border: 1px solid #81C784;
        }
        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 0.9em;
            color: #a9a9b3;
        }
        .checkbox-group input[type="checkbox"] {
            accent-color: #00ffc8;
            width: 16px;
            height: 16px;
        }
    </style>
</head>
<body>
    <!-- SPLASH SCREEN -->
    <div id="splash-screen">
        <div class="splash-loader"></div>
        <div class="splash-image-container">
            <?php include 'splash_config.php'; ?>
            <img src="<?php echo SPLASH_IMAGE_URL; ?>" alt="Welcome">
        </div>
    </div>

    <!-- AUTH CONTAINER -->
    <div class="auth-container" id="auth-container" style="display: none;">
        <div class="auth-card">
            <div class="auth-logo">
                <h1><?php echo APP_NAME; ?></h1>
                <p>Your Trusted Betting Platform</p>
            </div>

            <?php if ($error): ?>
                <div class="alert alert-error"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
            <?php endif; ?>

            <div class="auth-tabs">
                <button class="auth-tab active" id="login-tab" onclick="showLogin()">লগিন</button>
                <button class="auth-tab" id="register-tab" onclick="showRegister()">রেজিস্টার</button>
            </div>

            <!-- লগিন ফর্ম -->
            <form id="login-form" class="auth-form" method="POST" action="">
                <input type="hidden" name="login" value="1">
                <div class="form-group">
                    <label for="login-phone">ফোন নাম্বার</label>
                    <input type="tel" id="login-phone" name="phone" placeholder="01XXXXXXXXX" required>
                </div>
                <div class="form-group">
                    <label for="login-password">পাসওয়ার্ড</label>
                    <input type="password" id="login-password" name="password" placeholder="পাসওয়ার্ড" required>
                </div>
                <div class="checkbox-group">
                    <input type="checkbox" id="remember-me" name="remember">
                    <label for="remember-me">রিমেম্বার মি</label>
                </div>
                <button type="submit" class="submit-btn">লগিন</button>
            </form>

            <!-- রেজিস্ট্রেশন ফর্ম -->
            <form id="register-form" class="auth-form" method="POST" action="" style="display: none;">
                <input type="hidden" name="register" value="1">
                <div class="form-group">
                    <label for="register-name">পুরো নাম</label>
                    <input type="text" id="register-name" name="name" placeholder="আপনার পুরো নাম" required>
                </div>
                <div class="form-group">
                    <label for="register-phone">ফোন নাম্বার</label>
                    <input type="tel" id="register-phone" name="phone" placeholder="01XXXXXXXXX" required>
                </div>
                <div class="form-group">
                    <label for="register-password">পাসওয়ার্ড</label>
                    <input type="password" id="register-password" name="password" placeholder="পাসওয়ার্ড (কমপক্ষে ৬ অক্ষর)" required>
                </div>
                <div class="form-group">
                    <label for="register-confirm-password">পাসওয়ার্ড নিশ্চিত করুন</label>
                    <input type="password" id="register-confirm-password" name="confirm_password" placeholder="পুনরায় পাসওয়ার্ড" required>
                </div>
                <div class="form-group">
                    <label for="referral-code-input">রেফারেল কোড (ঐচ্ছিক)</label>
                    <input type="text" id="referral-code-input" name="referral_code" placeholder="রেফারেল কোড (যদি থাকে)">
                </div>
                <button type="submit" class="submit-btn">রেজিস্টার</button>
            </form>
        </div>
    </div>

    <script>
        // SPLASH SCREEN
        window.addEventListener('load', () => {
            setTimeout(() => {
                const splash = document.getElementById('splash-screen');
                splash.classList.add('hidden');
                setTimeout(() => {
                    splash.style.display = 'none';
                    document.getElementById('auth-container').style.display = 'flex';
                }, 500);
            }, 3000);
        });

        // AUTH TABS
        function showLogin() {
            document.getElementById('login-form').style.display = 'flex';
            document.getElementById('register-form').style.display = 'none';
            document.getElementById('login-tab').classList.add('active');
            document.getElementById('register-tab').classList.remove('active');
        }
        
        function showRegister() {
            document.getElementById('login-form').style.display = 'none';
            document.getElementById('register-form').style.display = 'flex';
            document.getElementById('login-tab').classList.remove('active');
            document.getElementById('register-tab').classList.add('active');
        }

        // FORM VALIDATION
        document.getElementById('login-form')?.addEventListener('submit', function(e) {
            const phone = document.getElementById('login-phone').value;
            const password = document.getElementById('login-password').value;
            
            if (!phone || !password) {
                e.preventDefault();
                alert('ফোন নাম্বার এবং পাসওয়ার্ড প্রয়োজন');
                return false;
            }
            
            if (!/^01[3-9]\d{8}$/.test(phone)) {
                e.preventDefault();
                alert('সঠিক ফোন নাম্বার দিন');
                return false;
            }
        });

        document.getElementById('register-form')?.addEventListener('submit', function(e) {
            const password = document.getElementById('register-password').value;
            const confirm = document.getElementById('register-confirm-password').value;
            
            if (password !== confirm) {
                e.preventDefault();
                alert('পাসওয়ার্ড মেলেনি');
                return false;
            }
            
            if (password.length < 6) {
                e.preventDefault();
                alert('পাসওয়ার্ড কমপক্ষে ৬ অক্ষরের হতে হবে');
                return false;
            }
        });
    </script>
</body>
</html>